@echo off
setlocal EnableDelayedExpansion

REM ===============================
REM   Client Launcher (PRODUCTION)
REM ===============================

set "SCRIPT_DIR=%~dp0"
set "JAR_FILE=%SCRIPT_DIR%client.jar"

if not exist "%JAR_FILE%" (
    echo ERROR: client.jar not found!
    exit /b 1
)

REM ---- Detect Java ----
set "JAVA_EXE="
if defined JAVA_HOME (
    if exist "%JAVA_HOME%\bin\javaw.exe" (
        set "JAVA_EXE=%JAVA_HOME%\bin\javaw.exe"
    ) else if exist "%JAVA_HOME%\bin\java.exe" (
        set "JAVA_EXE=%JAVA_HOME%\bin\java.exe"
    )
)

if not defined JAVA_EXE (
    for %%J in (javaw.exe java.exe) do (
        set "JAVA_EXE=%%~$PATH:J"
        if defined JAVA_EXE goto :foundJava
    )
)

:foundJava
if not defined JAVA_EXE (
    echo ERROR: Java not found.
    exit /b 1
)

REM ---- Detect JavaFX ----
set "JAVAFX_LIB="
for %%D in (
    "C:\Program Files\Java\javafx-sdk-25.0.1\lib"
    "C:\Program Files\Java\javafx-sdk-25\lib"
    "C:\Java\javafx\lib"
) do (
    if exist %%D (
        set "JAVAFX_LIB=%%~D"
        goto :foundFX
    )
)

:foundFX
if not defined JAVAFX_LIB (
    echo ERROR: JavaFX not found.
    exit /b 1
)

REM ---- Launch JavaFX app without waiting ----
start "" "%JAVA_EXE%" --module-path "%JAVAFX_LIB%" --add-modules javafx.controls,javafx.fxml -jar "%JAR_FILE%"

endlocal
exit /b
