/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.threads;

final class JDKSpecific {
    private JDKSpecific() {
    }

    static void setThreadContextClassLoader(Thread thread, ClassLoader classLoader) {
        thread.setContextClassLoader(classLoader);
    }

    static ClassLoader getThreadContextClassLoader(Thread thread) {
        return thread.getContextClassLoader();
    }

    static final class ThreadAccess {
        private static final long threadLocalMapOffs;
        private static final long inheritableThreadLocalMapOffs;

        ThreadAccess() {
        }

        static void clearThreadLocals() {
            Thread thread = Thread.currentThread();
            unsafe.putObject(thread, threadLocalMapOffs, null);
            unsafe.putObject(thread, inheritableThreadLocalMapOffs, null);
        }

        static {
            try {
                threadLocalMapOffs = unsafe.objectFieldOffset(Thread.class.getDeclaredField("threadLocals"));
                inheritableThreadLocalMapOffs = unsafe.objectFieldOffset(Thread.class.getDeclaredField("inheritableThreadLocals"));
            }
            catch (NoSuchFieldException e) {
                NoSuchFieldError error = new NoSuchFieldError(e.getMessage());
                error.setStackTrace(e.getStackTrace());
                throw error;
            }
        }
    }
}

