/*
 * Decompiled with CFR 0.152.
 */
package com.sysrefiners.enterprise.service;

import com.sysrefiners.enterprise.model.Tracker;
import jakarta.ejb.Stateless;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.TypedQuery;
import java.time.LocalDateTime;
import java.util.List;
import java.util.UUID;

@Stateless
public class TrackerService {
    @PersistenceContext(unitName="enterprise-appPersistenceUnit")
    private EntityManager em;

    public Tracker createTracker(String identity) {
        Tracker tracker = new Tracker();
        tracker.setIdentity(identity);
        String rawId = UUID.randomUUID().toString();
        tracker.setTrackingId(rawId.substring(0, 8));
        tracker.setDateCreated(LocalDateTime.now());
        this.em.persist((Object)tracker);
        return tracker;
    }

    public void trackVisit(String trackingId) {
        if (trackingId == null || trackingId.trim().isEmpty()) {
            return;
        }
        try {
            TypedQuery query = this.em.createQuery("SELECT t FROM Tracker t WHERE t.trackingId = :tid", Tracker.class);
            query.setParameter("tid", (Object)trackingId);
            List result = query.getResultList();
            if (!result.isEmpty()) {
                Tracker tracker = (Tracker)result.get(0);
                tracker.setDateViewed(LocalDateTime.now());
                tracker.setViewCount(tracker.getViewCount() + 1);
                this.em.merge((Object)tracker);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<Tracker> getAllTrackers() {
        return this.em.createQuery("SELECT t FROM Tracker t ORDER BY t.dateCreated DESC", Tracker.class).getResultList();
    }

    public void deleteTracker(Tracker tracker) {
        Tracker existing;
        if (tracker != null && tracker.getId() != null && (existing = (Tracker)this.em.find(Tracker.class, (Object)tracker.getId())) != null) {
            this.em.remove((Object)existing);
        }
    }

    public void incrementAiInteraction(String trackingId) {
        this.updateCounter(trackingId, "ai");
    }

    public void incrementPortfolioInteraction(String trackingId) {
        this.updateCounter(trackingId, "portfolio");
    }

    public void incrementContactSubmission(String trackingId) {
        this.updateCounter(trackingId, "contact");
    }

    public String getIdentity(String trackingId) {
        if (trackingId == null || trackingId.trim().isEmpty()) {
            return null;
        }
        try {
            TypedQuery query = this.em.createQuery("SELECT t FROM Tracker t WHERE t.trackingId = :tid", Tracker.class);
            query.setParameter("tid", (Object)trackingId);
            List result = query.getResultList();
            if (!result.isEmpty()) {
                return ((Tracker)result.get(0)).getIdentity();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private void updateCounter(String trackingId, String type) {
        if (trackingId == null || trackingId.trim().isEmpty()) {
            return;
        }
        try {
            TypedQuery query = this.em.createQuery("SELECT t FROM Tracker t WHERE t.trackingId = :tid", Tracker.class);
            query.setParameter("tid", (Object)trackingId);
            List result = query.getResultList();
            if (!result.isEmpty()) {
                Tracker tracker = (Tracker)result.get(0);
                if ("ai".equals(type)) {
                    tracker.setAiInteractions(tracker.getAiInteractions() + 1);
                } else if ("portfolio".equals(type)) {
                    tracker.setPortfolioInteractions(tracker.getPortfolioInteractions() + 1);
                } else if ("contact".equals(type)) {
                    tracker.setContactFormSubmitted(tracker.getContactFormSubmitted() + 1);
                }
                this.em.merge((Object)tracker);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

