/*
 * Decompiled with CFR 0.152.
 */
package com.sysrefiners.enterprise.service;

import com.sysrefiners.enterprise.model.GlobalStats;
import jakarta.annotation.PostConstruct;
import jakarta.ejb.Lock;
import jakarta.ejb.LockType;
import jakarta.ejb.Singleton;
import jakarta.ejb.Startup;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;

@Singleton
@Startup
public class GlobalStatsService {
    @PersistenceContext(unitName="enterprise-appPersistenceUnit")
    private EntityManager em;

    @PostConstruct
    public void init() {
        GlobalStats stats = (GlobalStats)this.em.find(GlobalStats.class, (Object)"GLOBAL");
        if (stats == null) {
            stats = new GlobalStats();
            stats.setTotalVisits(0L);
            this.em.persist((Object)stats);
        }
    }

    public long incrementAndGetVisits() {
        GlobalStats stats = (GlobalStats)this.em.find(GlobalStats.class, (Object)"GLOBAL");
        if (stats == null) {
            stats = new GlobalStats();
            stats.setId("GLOBAL");
            stats.setTotalVisits(0L);
            this.em.persist((Object)stats);
            this.em.flush();
        }
        stats.setTotalVisits(stats.getTotalVisits() + 1L);
        this.em.merge((Object)stats);
        System.out.println("GlobalStatsService: Visitor count incremented to " + stats.getTotalVisits());
        return stats.getTotalVisits();
    }

    @Lock(value=LockType.READ)
    public long getVisits() {
        GlobalStats stats = (GlobalStats)this.em.find(GlobalStats.class, (Object)"GLOBAL");
        return stats != null ? stats.getTotalVisits() : 0L;
    }
}

