/*
 * Decompiled with CFR 0.152.
 */
package com.sysrefiners.enterprise;

import com.sysrefiners.enterprise.model.Project;
import jakarta.annotation.PostConstruct;
import jakarta.ejb.Singleton;
import jakarta.ejb.Startup;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.util.Arrays;
import java.util.List;

@Singleton
@Startup
public class SeedDataBean {
    @PersistenceContext(unitName="enterprise-appPersistenceUnit")
    private EntityManager em;

    @PostConstruct
    public void init() {
        Long count = (Long)this.em.createQuery("SELECT COUNT(p) FROM Project p", Long.class).getSingleResult();
        if (count == 0L) {
            System.out.println("Seeding 16 initial projects...");
            this.createProject("Kiosk AI", "A voice-powered kiosk system for handling customer orders through natural language interaction.", Arrays.asList("Rust", "Gemini Live", "Raspberry PI 5"), "COMPLETED", "", "", "https://github.com/ghostidentity/voice-ai-kiosk");
            this.createProject("NitroPI HSM", "A utility app that interacts on nitrokey HSM 2 device.", Arrays.asList("GO", "HSM"), "INSTALLABLE", "https://youtu.be/swr0XojhdxU", "", "https://github.com/ghostidentity/nitropihsm");
            this.createProject("Pageant Tabulation", "Specialized software used to efficiently and accurately calculate and display results in a pageant or beauty contest.", Arrays.asList("C#", ".NET"), "COMPLETED", "https://youtu.be/Qyx3Va04dUI", null, null);
            this.createProject("Patient Emergency System", "A quick easy way to request nurse assistance with just a push on a button.", Arrays.asList("JAVA", "JAVAFX"), "COMPLETED", "https://youtu.be/60Qud2tsA2k", null, null);
            this.createProject("Automated Item Tracker", "A repair-job tracking system that utilizes lan connectivity.", Arrays.asList("JAVA", "NETWORK"), "ARCHIVED", "https://youtu.be/cHpINncnbkA", null, null);
            this.createProject("Inventory System", "An all in one inventory system that extends with product management. sales, customer and personnel.", Arrays.asList("JAVA", "SQL"), "COMPLETED", "https://youtu.be/dI3p0WmdFTg", null, null);
            this.createProject("Integrated Health Checker", "A system that integrates with thermal sensor to provide realtime status notification.", Arrays.asList("ARDUINO", "SENSORS"), "PROTOTYPE", "https://youtu.be/47NL4qeeIbo", null, null);
            this.createProject("Automated Water Dispenser", "An arduino based liquid dispenser that integrates with motion sensor.", Arrays.asList("ARDUINO", "C++"), "PROTOTYPE", "https://youtu.be/BaOxA_1HV3U", null, null);
            this.createProject("Criminal Identification System", "A system that integrates with OpenCV for prison system.", Arrays.asList("PYTHON", "OPENCV"), "ARCHIVED", "https://youtu.be/ip1-l49ttGY", null, null);
            this.createProject("FuseCrypt", "Combines industry-standard cryptographic algorithms to encrypt sensitive data and offers end-to-end encrypted local network communication.", Arrays.asList("JAVA", "CRYPTO"), "COMPLETED", "https://youtu.be/r_LGQ7WJcFs", "https://apps.microsoft.com/detail/9mz5jbdptbm8", null);
            this.createProject("Resume Analyzer", "Allows HR personnel to screen applicants by resume against job description specified during creation.", Arrays.asList("C#", "OpenAI"), "LIVE", "https://youtu.be/-sIGQGY19ro", "https://apps.microsoft.com/detail/9pkqgm0qlbq7", null);
            this.createProject("Automated Identity", "Centralized Access Control and Identity System with the use of QR Code for multi-location organizations.", Arrays.asList("C#", "QR"), "ARCHIVED", "https://youtu.be/8JBY0La1bqM", null, null);
            this.createProject("Spectral Control", "Sophisticated system that integrates with Yubikey as access control device while leveraging PCQ, TPM and HSM.", Arrays.asList("GO", "C#", "RUST"), "LIVE", "https://youtu.be/w0EdD1Yilqs", "https://apps.microsoft.com/detail/9mxf2x6vl12s", null);
            this.createProject("PCQ Key Generator", "Generates public/private keys for NTRU/Kyber/Dilithium.", Arrays.asList("RUST", "CRYPTO"), "TOOL", null, null, "https://pcq.leapcell.app/");
            this.createProject("Military Identification System", "An access management system that integrates with RFID card.", Arrays.asList("C#", "RFID"), "ARCHIVED", "https://youtu.be/OBmYB9c90Os", null, null);
            this.createProject("Order Notifier", "An app that provides order status updates using push button through ESPNow protocol.", Arrays.asList("ESP32", "C++"), "DEPLOYED", "https://youtu.be/A4PDod_ZLZM", "https://apps.microsoft.com/detail/9n0vxrvp1knl", null);
        }
    }

    private void createProject(String title, String description, List<String> techStack, String status, String yt, String dl, String doc) {
        Project p = new Project();
        p.setTitle(title);
        p.setDescription(description);
        p.setTechStack(techStack);
        p.setStatus(status);
        p.setYoutubeUrl(yt);
        p.setDownloadUrl(dl);
        p.setDocumentationUrl(doc);
        this.em.persist((Object)p);
    }
}

