/*
 * Decompiled with CFR 0.152.
 */
package com.sysrefiners.enterprise;

import com.sysrefiners.MessageSenderBean;
import com.sysrefiners.enterprise.MessageService;
import com.sysrefiners.enterprise.Messager;
import com.sysrefiners.enterprise.MyBusinessServiceLocal;
import com.sysrefiners.enterprise.MyBusinessServiceRemote;
import jakarta.annotation.Resource;
import jakarta.annotation.security.PermitAll;
import jakarta.annotation.security.RolesAllowed;
import jakarta.ejb.SessionContext;
import jakarta.ejb.Stateful;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import java.io.StringReader;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@Stateful(name="Foo")
public class MyBusinessService
implements MyBusinessServiceRemote,
MyBusinessServiceLocal {
    @Resource
    private SessionContext sessionContext;
    @Inject
    private MessageService messageService;
    @Inject
    private MessageSenderBean messageSenderBean;
    @Inject
    @Named(value="vtExecutor")
    private ExecutorService virtualThreadExecutor;

    @Override
    @PermitAll
    public String sayHelloInternal(String name) {
        String caller = this.sessionContext.getCallerPrincipal().getName();
        long totalRecords = this.messageService.getAllMessages().size();
        return "Hello sayHelloInternal" + name + ", there's a total of " + totalRecords + " records at the moment. Called by " + caller + ".";
    }

    @Override
    @RolesAllowed(value={"admin"})
    public String sayHelloExternal(String name) {
        String caller = this.sessionContext.getCallerPrincipal().getName();
        String messageContent = "Hello  sayHelloExternal" + name + "! (called by " + caller + ")";
        Future<String> asyncResult = this.virtualThreadExecutor.submit(() -> {
            Thread currentThread = Thread.currentThread();
            System.out.println("Async task started on: " + currentThread.getName() + " (Virtual: " + currentThread.isVirtual() + ")");
            this.messageSenderBean.sendMessage(messageContent);
            Messager message = new Messager();
            message.setText(messageContent);
            this.messageService.saveMessage(message);
            return "SUCCESS";
        });
        long totalRecords = this.messageService.getAllMessages().size();
        return "\u2713 Message Processing Initiated Async\n\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\nContent: " + messageContent + "\nCaller: " + caller + "\nStatus: Task submitted to Virtual Thread executor (Result: " + (asyncResult.isDone() ? "Complete" : "Pending") + ")\nTotal Records: " + totalRecords + "\n\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501";
    }

    @RolesAllowed(value={"admin"})
    public String sayHelloExternalBackup(String name) {
        String caller = this.sessionContext.getCallerPrincipal().getName();
        String messageContent = "Hello  sayHelloExternal" + name + "! (called by " + caller + ")";
        Future<String> asyncResult = this.virtualThreadExecutor.submit(() -> {
            Thread currentThread = Thread.currentThread();
            System.out.println("Async task started on: " + currentThread.getName() + " (Virtual: " + currentThread.isVirtual() + ")");
            this.messageSenderBean.sendMessage(messageContent);
            Messager message = new Messager();
            message.setText(messageContent);
            this.messageService.saveMessage(message);
            return "SUCCESS";
        });
        long totalRecords = this.messageService.getAllMessages().size();
        return "\u2713 Message Processing Initiated Async\n\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\nContent: " + messageContent + "\nCaller: " + caller + "\nStatus: Task submitted to Virtual Thread executor (Result: " + (asyncResult.isDone() ? "Complete" : "Pending") + ")\nTotal Records: " + totalRecords + "\n\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501";
    }

    @Override
    @PermitAll
    public String askAI(String prompt) {
        String apiKey = "FGLSpKkGMNDY3muUlyDHZPWXQxMdB7dc";
        if (apiKey == null || apiKey.isEmpty()) {
            return "Mk_AI_OFL: API Key Issue. (Simulated message)";
        }
        try {
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create("https://api.mistral.ai/v1/agents/completions")).header("Content-Type", "application/json").header("Authorization", "Bearer " + apiKey).POST(HttpRequest.BodyPublishers.ofString(this.createMistralAgentRequest(prompt))).build();
            HttpResponse<String> response = HttpClient.newHttpClient().send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() == 200) {
                return this.extractContentFromResponse(response.body());
            }
            return "Error: Mistral API returned status " + response.statusCode() + " Body: " + response.body();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "Error processing AI request: " + e.getMessage();
        }
    }

    private String createMistralAgentRequest(String prompt) {
        String escapedPrompt = prompt.replace("\"", "\\\"").replace("\n", " ");
        String systemContext = "You are Zero, Mark Tagab's personal assistant. You are interacting with a VISITOR to Mark's portfolio. Do NOT address the user as Mark. You MUST ONLY answer questions based on the following portfolio data. If the answer is not in this data, strictly state you do not know. Keep your English responses direct and precise. Mark is based in the Philippines. EMAIL: mtagab@outlook.com. SOCIALS: [LinkedIn: linkedin.com/in/mtagab, GitHub: github.com/ghostidentity]. BIO: Software Engineer with a background in IT and OT. Specialized in simple, elegant solutions. SKILLS: [Java, Jakarta EE, Wildfly, Spring Framework, C#, Docker/Kubernetes, Cloud (AWS/Azure), Security (HSM, TPM, Kerberos), IoT, AI/LLMs]. PROJECTS: 1. NitroPI HSM (Nitrokey HSM 2 utility). 2. Pageant Tabulation (C# scoring system). 3. Patient Emergency System (JavaFx nurse call). 4. FuseCrypt (Cryptography/Security tool). 5. Spectral Control (Yubikey/TPM integration). 6. Automated Identity (QR Code Access Control). 7. RadNet (Radiology Info System). 8. Military ID System (RFID). CONTACT: Reach out via email or the contact form on this site.";
        String escapedSystemContext = systemContext.replace("\"", "\\\"");
        return "{\"agent_id\": \"ag_019b2795a5bb73f8b272abf4419b9abc\",\"messages\": [  {\"role\": \"system\", \"content\": \"" + escapedSystemContext + "\"},  {\"role\": \"user\", \"content\": \"" + escapedPrompt + "\"}]}";
    }

    private String extractContentFromResponse(String jsonResponse) {
        JsonReader jsonReader = Json.createReader(new StringReader(jsonResponse));
        try {
            JsonObject jsonObject = jsonReader.readObject();
            String string = jsonObject.getJsonArray("choices").getJsonObject(0).getJsonObject("message").getString("content");
            if (jsonReader != null) {
                jsonReader.close();
            }
            return string;
        }
        catch (Throwable throwable) {
            try {
                if (jsonReader != null) {
                    try {
                        jsonReader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception e) {
                return "Error parsing response: " + e.getMessage();
            }
        }
    }
}

