/*
 * Decompiled with CFR 0.152.
 */
package com.sysrefiners.enterprise;

import com.sysrefiners.enterprise.Messager;
import jakarta.annotation.Resource;
import jakarta.ejb.Singleton;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.transaction.Transactional;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.UUID;
import javax.sql.DataSource;

@Singleton
public class MessageService {
    @PersistenceContext
    private EntityManager entityManager;
    @Resource(lookup="java:jboss/datasources/ExampleDS")
    private DataSource dataSource;

    public void saveMessage(Messager message) {
        this.entityManager.persist((Object)message);
    }

    public List<Messager> getAllMessages() {
        return this.entityManager.createQuery("SELECT m FROM Messager m", Messager.class).getResultList();
    }

    @Transactional
    public void deleteMessage(UUID id) {
        Messager message = (Messager)this.entityManager.find(Messager.class, (Object)id);
        if (message != null) {
            this.entityManager.remove((Object)message);
        }
    }

    public Messager getMessageById(UUID id) {
        return (Messager)this.entityManager.find(Messager.class, (Object)id);
    }

    public void exampleDatabaseOperation() throws SQLException {
        try (Connection connection = this.dataSource.getConnection();){
            System.out.println("Connection: " + String.valueOf(connection));
        }
    }
}

