/*
 * Decompiled with CFR 0.152.
 */
package com.sysrefiners.enterprise;

import com.sysrefiners.enterprise.AIChatRemote;
import com.sysrefiners.enterprise.PortfolioService;
import com.sysrefiners.enterprise.dto.ContactRecord;
import com.sysrefiners.enterprise.model.ChatLog;
import com.sysrefiners.enterprise.model.ContactMessage;
import com.sysrefiners.enterprise.model.Project;
import com.sysrefiners.enterprise.repository.ChatLogRepository;
import com.sysrefiners.enterprise.repository.ContactRepository;
import com.sysrefiners.enterprise.service.GlobalStateService;
import jakarta.ejb.LocalBean;
import jakarta.ejb.Stateless;
import jakarta.ejb.TransactionAttribute;
import jakarta.ejb.TransactionAttributeType;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import java.io.StringReader;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@Stateless(name="CommunicationService")
@LocalBean
public class CommunicationService
implements AIChatRemote {
    @Inject
    @Named(value="vtExecutor")
    private ExecutorService executor;
    @Inject
    private ContactRepository contactRepository;
    @Inject
    private ChatLogRepository chatLogRepository;
    @Inject
    private PortfolioService portfolioService;
    @Inject
    private GlobalStateService globalState;

    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public void saveContact(ContactMessage msg) {
        this.contactRepository.save(msg);
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public void saveContact(ContactRecord record) {
        ContactMessage msg = new ContactMessage(record.name(), record.email(), record.message());
        this.contactRepository.save(msg);
    }

    @Override
    public String chat(String prompt, String username) {
        try {
            Future<String> future = this.executor.submit(() -> this.processAIRequest(prompt, username));
            String response = future.get();
            this.saveChatLog(username, prompt, response);
            return response;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "Error: " + e.getMessage();
        }
    }

    private void saveChatLog(String username, String prompt, String response) {
        try {
            ChatLog log = new ChatLog(username, prompt, response);
            this.chatLogRepository.save(log);
        }
        catch (Exception e) {
            System.err.println("Failed to save chat log: " + e.getMessage());
        }
    }

    private String processAIRequest(String prompt, String username) {
        String apiKey = "FGLSpKkGMNDY3muUlyDHZPWXQxMdB7dc";
        if (apiKey == null || apiKey.isEmpty()) {
            return "Mk_AI_OFL: API Key Issue.";
        }
        try {
            Object systemContext = this.getSystemContext(username, null);
            boolean adminOnline = this.globalState != null && this.globalState.isAdminOnline();
            String adminStatus = adminOnline ? "ONLINE" : "OFFLINE";
            systemContext = (String)systemContext + " SYSTEM STATUS: Admin is " + adminStatus + ".";
            ArrayList<JsonObject> conversation = new ArrayList<JsonObject>();
            conversation.add(Json.createObjectBuilder().add("role", "system").add("content", (String)systemContext).build());
            conversation.add(Json.createObjectBuilder().add("role", "user").add("content", prompt).build());
            int maxIterations = 5;
            for (int i = 0; i < maxIterations; ++i) {
                String content;
                JsonArrayBuilder messagesBuilder = Json.createArrayBuilder();
                for (JsonObject msg : conversation) {
                    messagesBuilder.add(msg);
                }
                JsonObject requestJson = Json.createObjectBuilder().add("agent_id", "ag_019b4dc9e44c73d7878e80b35f34a45e").add("messages", messagesBuilder).build();
                System.out.println("=== MISTRAL API REQUEST (Iteration " + (i + 1) + ") ===");
                System.out.println(requestJson.toString());
                System.out.println("===========================");
                HttpRequest request = HttpRequest.newBuilder().uri(URI.create("https://api.mistral.ai/v1/agents/completions")).header("Content-Type", "application/json").header("Authorization", "Bearer " + apiKey).POST(HttpRequest.BodyPublishers.ofString(requestJson.toString())).build();
                HttpResponse<String> response = HttpClient.newHttpClient().send(request, HttpResponse.BodyHandlers.ofString());
                System.out.println("=== MISTRAL API RESPONSE ===");
                System.out.println("Status: " + response.statusCode());
                System.out.println("Body: " + response.body());
                System.out.println("============================");
                if (response.statusCode() != 200) {
                    return "Error: Mistral API returned status " + response.statusCode();
                }
                JsonReader jsonReader = Json.createReader(new StringReader(response.body()));
                JsonObject jsonObject = jsonReader.readObject();
                JsonObject message = jsonObject.getJsonArray("choices").getJsonObject(0).getJsonObject("message");
                jsonReader.close();
                conversation.add(message);
                if (message.containsKey("tool_calls") && !message.isNull("tool_calls")) {
                    JsonArray toolCalls = message.getJsonArray("tool_calls");
                    System.out.println("AI requested " + toolCalls.size() + " tool call(s). Executing...");
                    for (int j = 0; j < toolCalls.size(); ++j) {
                        JsonObject toolCall = toolCalls.getJsonObject(j);
                        String toolId = toolCall.getString("id");
                        String toolName = toolCall.getJsonObject("function").getString("name");
                        String toolResult = this.executeTool(toolName);
                        System.out.println("  -> Executed " + toolName + "() -> " + toolResult);
                        conversation.add(Json.createObjectBuilder().add("role", "tool").add("content", toolResult).add("tool_call_id", toolId).build());
                    }
                    continue;
                }
                if (message.containsKey("content") && !message.isNull("content") && !(content = message.getString("content")).trim().isEmpty()) {
                    return content;
                }
                return "AI response was empty.";
            }
            return "Error: Maximum tool execution iterations reached.";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "Error processing AI request: " + e.getMessage();
        }
    }

    private String executeTool(String toolName) {
        switch (toolName) {
            case "admin_connected": {
                boolean isAdminOnline = this.globalState != null && this.globalState.isAdminOnline();
                return Json.createObjectBuilder().add("available", isAdminOnline).build().toString();
            }
        }
        return Json.createObjectBuilder().add("error", "Tool not supported in ACP mode: " + toolName).build().toString();
    }

    @Override
    public String chatWithTools(String messagesJson) {
        try {
            JsonArray messages;
            try (JsonReader reader = Json.createReader(new StringReader(messagesJson));){
                messages = reader.readArray();
            }
            JsonArray finalMessages = messages;
            Future<String> future = this.executor.submit(() -> this.processAIRequestRaw(finalMessages));
            return future.get();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "{\"error\": \"Backend Error: " + e.getMessage() + "\"}";
        }
    }

    private String processAIRequestRaw(JsonArray messages) {
        String apiKey = "FGLSpKkGMNDY3muUlyDHZPWXQxMdB7dc";
        if (apiKey == null || apiKey.isEmpty()) {
            return "{\"error\": \"API Key Issue.\"}";
        }
        try {
            JsonObject requestJson = Json.createObjectBuilder().add("agent_id", "ag_019b4dc9e44c73d7878e80b35f34a45e").add("messages", messages).build();
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create("https://api.mistral.ai/v1/agents/completions")).header("Content-Type", "application/json").header("Authorization", "Bearer " + apiKey).POST(HttpRequest.BodyPublishers.ofString(requestJson.toString())).build();
            HttpResponse<String> response = HttpClient.newHttpClient().send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() == 200) {
                return this.extractFullResponse(response.body());
            }
            return "{\"error\": \"Mistral API returned status " + response.statusCode() + ": " + response.body() + "\"}";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "{\"error\": \"Error processing AI request: " + e.getMessage() + "\"}";
        }
    }

    @Override
    public String getSystemContext(String username, String trackingId) {
        StringBuilder projectsContext = new StringBuilder();
        List<Project> projects = this.portfolioService.getProjects();
        if (projects != null) {
            for (int i = 0; i < projects.size(); ++i) {
                Project p = projects.get(i);
                projectsContext.append(i + 1 + ". " + p.getTitle() + ": " + p.getDescription() + " (Stack: " + String.join((CharSequence)", ", p.getTechStack()) + "). ");
            }
        }
        System.out.println("DEBUG: getSystemContext called for " + username + " ID: " + trackingId);
        Object idInfo = trackingId != null ? "User's Tracking ID is '" + trackingId + "'. " : "";
        boolean isGuest = trackingId == null;
        Object idInstruction = isGuest ? "6. You CURRENTLY DO NOT HAVE a verified Tracking ID for this user. Routing and Resume Download functionalities are DISABLED until a valid ID is provided. If the user provides an ID (e.g. 'my id is...'), call `chat_approval` with that ID immediately to verify it. Do not hallucinate or generate an ID." : "6. Since you HAVE the Valid Tracking ID (" + trackingId + "), if the user asks to connect, IMMEDIATELY call `chat_approval` with this ID. If the user explicitly provides a DIFFERENT ID, call `chat_approval` with the NEW ID.";
        return "Session Context: User: " + username + " (Operative). " + (String)idInfo + "Context: Mark Tagab's Portfolio (" + projects.size() + " projects). Instructions: 1. Answer the user's input directly and concisely. 2. If the user greets you (e.g., 'hello'), respond politely as Zero and offer assistance. 3. Only list project details or simulated status logs if the user explicitly asks for them. 4. If the user asks for a human or admin, YOU MUST ALWAYS use the `admin_connected` tool to check their status first. Do not assume their status. 5. If `admin_connected` returns false, tell them no operative is currently available. " + (String)idInstruction + " 7. If the user asks for the resume, call `download_resume` with their Tracking ID. If you don't have it, ask for it first. NO NEED to call `chat_approval` for this. 8. If `chat_approval` returns success/accepted, inform the user they are connected and ask what they would like to say to Mark. 9. ONLY call `route_message` if the user explicitly provides a message to send AFTER the ID has been approved. \n11. CRITICAL: Check the `chat_approval` tool output. The `profile.identity` field is the source of truth.\n    - If `identity` is 'Anonymous', VERIFICATION FAILED. Tell the user they must provide a valid ID to proceed. DO NOT say 'Identity verified'.\n    - If `identity` is NOT 'Anonymous' (e.g. 'Royal Knight'), VERIFICATION SUCCEEDED. You may proceed to ask what they want to say.\n12. Always check tool outputs before responding. Do not assume success.\nPROJECT DATA: " + projectsContext.toString();
    }

    private String createMistralAgentRequest(String prompt, String username) {
        System.out.println("AI Request - User: " + username + ", Prompt: " + prompt);
        Object systemContext = this.getSystemContext(username, null);
        boolean adminOnline = this.globalState != null && this.globalState.isAdminOnline();
        String adminStatus = adminOnline ? "ONLINE" : "OFFLINE";
        systemContext = (String)systemContext + " SYSTEM STATUS: Admin is " + adminStatus + ".";
        JsonObject requestJson = Json.createObjectBuilder().add("agent_id", "ag_019b2795a5bb73f8b272abf4419b9abc").add("messages", Json.createArrayBuilder().add(Json.createObjectBuilder().add("role", "system").add("content", (String)systemContext)).add(Json.createObjectBuilder().add("role", "user").add("content", prompt))).build();
        return requestJson.toString();
    }

    private String extractContentFromResponse(String jsonResponse) {
        JsonReader jsonReader = Json.createReader(new StringReader(jsonResponse));
        try {
            JsonObject jsonObject = jsonReader.readObject();
            String string = jsonObject.getJsonArray("choices").getJsonObject(0).getJsonObject("message").getString("content");
            if (jsonReader != null) {
                jsonReader.close();
            }
            return string;
        }
        catch (Throwable throwable) {
            try {
                if (jsonReader != null) {
                    try {
                        jsonReader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception e) {
                return "Error parsing response: " + e.getMessage();
            }
        }
    }

    private String extractFullResponse(String jsonResponse) {
        JsonReader jsonReader = Json.createReader(new StringReader(jsonResponse));
        try {
            JsonObject jsonObject = jsonReader.readObject();
            JsonObject message = jsonObject.getJsonArray("choices").getJsonObject(0).getJsonObject("message");
            String string = message.toString();
            if (jsonReader != null) {
                jsonReader.close();
            }
            return string;
        }
        catch (Throwable throwable) {
            try {
                if (jsonReader != null) {
                    try {
                        jsonReader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception e) {
                return "{\"content\": \"Error parsing backend response: " + e.getMessage() + "\"}";
            }
        }
    }
}

