/*
 * Decompiled with CFR 0.152.
 */
package com.sysrefiners.enterprise;

import com.sysrefiners.enterprise.model.ContactMessage;
import com.sysrefiners.enterprise.model.Project;
import jakarta.ejb.Stateless;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.util.List;

@Stateless
public class AdminDashboardBean {
    @PersistenceContext(unitName="enterprise-appPersistenceUnit")
    private EntityManager em;

    public void saveContact(ContactMessage msg) {
        this.em.persist((Object)msg);
    }

    public void updateContact(ContactMessage msg) {
        this.em.merge((Object)msg);
    }

    public long getAIInteractionCount() {
        return (Long)this.em.createQuery("SELECT COUNT(c) FROM ChatLog c", Long.class).getSingleResult();
    }

    public long getContactMessageCount() {
        return (Long)this.em.createQuery("SELECT COUNT(m) FROM ContactMessage m", Long.class).getSingleResult();
    }

    public long getTotalProjectCount() {
        try {
            return (Long)this.em.createQuery("SELECT COUNT(p) FROM Project p", Long.class).getSingleResult();
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public List<ContactMessage> getAllContactMessages() {
        return this.em.createQuery("SELECT m FROM ContactMessage m ORDER BY m.timestamp DESC", ContactMessage.class).getResultList();
    }

    public List<Project> getAllProjects() {
        return this.em.createQuery("SELECT p FROM Project p", Project.class).getResultList();
    }
}

