/*
 * Decompiled with CFR 0.152.
 */
import com.sysrefiners.enterprise.AIChatRemote;
import com.sysrefiners.enterprise.MyBusinessServiceRemote;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import java.io.StringReader;
import java.util.Properties;
import javax.naming.InitialContext;

public class TestClient {
    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("Usage: java -cp <jar> TestClient <username> <password> [message]");
            return;
        }
        String username = args[0];
        String password = args[1];
        String message = args.length > 2 ? args[2] : "Hey is mark available?";
        System.out.println("--- AI Connection Client ---");
        System.out.println("Target: http-remoting://sysrefiners.com:8080");
        System.out.println("User:   " + username);
        try {
            Properties props = new Properties();
            props.put("java.naming.factory.initial", "org.wildfly.naming.client.WildFlyInitialContextFactory");
            props.put("java.naming.provider.url", "http-remoting://localhost:8080");
            props.put("jboss.naming.client.ejb.context", (Object)true);
            props.put("jboss.naming.client.connect.options.org.xnio.Options.SSL_ENABLED", "true");
            props.put("java.naming.security.principal", username);
            props.put("java.naming.security.credentials", password);
            System.out.println("Connecting...");
            InitialContext ctx = new InitialContext(props);
            System.out.println("\n--- AI INTERACTION TEST ---");
            String aiJndi = "ejb:enterprise-app/enterprise-app-ejb/CommunicationService!com.sysrefiners.enterprise.AIChatRemote";
            System.out.println("Looking up AI EJB: " + aiJndi);
            AIChatRemote aiService = (AIChatRemote)ctx.lookup(aiJndi);
            System.out.println("Retrieving system context for " + username + "...");
            Object systemContext = aiService.getSystemContext(username, null);
            systemContext = (String)systemContext + " [ACP SESSION: You are chatting through a terminal.]";
            JsonArrayBuilder conversationBuilder = Json.createArrayBuilder();
            conversationBuilder.add(Json.createObjectBuilder().add("role", "system").add("content", (String)systemContext));
            conversationBuilder.add(Json.createObjectBuilder().add("role", "user").add("content", message));
            System.out.println("Sending prompt to AI...");
            String rawJsonResponse = aiService.chatWithTools(conversationBuilder.build().toString());
            String finalResponse = TestClient.handleAIResponse(aiService, conversationBuilder, rawJsonResponse);
            System.out.println("\n[ZERO]: " + finalResponse);
            System.out.println("---------------------------");
            System.out.println("\n--- EJB CONNECTIVITY TEST ---");
            String jndiName = "ejb:enterprise-app/enterprise-app-ejb/Foo!com.sysrefiners.enterprise.MyBusinessServiceRemote";
            System.out.println("Looking up EJB: " + jndiName);
            MyBusinessServiceRemote service = (MyBusinessServiceRemote)ctx.lookup(jndiName);
            System.out.println("Invoking sayHelloExternal...");
            String response = service.sayHelloExternal(message);
            System.out.println("--- RESPONSE ---");
            System.out.println(response);
            System.out.println("----------------");
            ctx.close();
        }
        catch (Exception e) {
            System.err.println("\u274c Error: " + e.getMessage());
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String handleAIResponse(AIChatRemote aiService, JsonArrayBuilder conversation, String rawJson) {
        try {
            JsonArray toolCalls;
            block24: {
                String content;
                JsonReader reader = Json.createReader(new StringReader(rawJson));
                JsonObject messageObj = reader.readObject();
                if (messageObj.containsKey("content") && !messageObj.isNull("content") && !(content = messageObj.getString("content")).trim().isEmpty()) {
                    String string = content;
                    return string;
                }
                if (messageObj.containsKey("tool_calls")) {
                    toolCalls = messageObj.getJsonArray("tool_calls");
                    System.out.println("AI requested " + toolCalls.size() + " tool call(s). Processing...");
                    conversation.add(messageObj);
                    break block24;
                } else {
                    Object object;
                    if (messageObj.containsKey("error")) {
                        object = "AI Error: " + messageObj.getString("error");
                        return object;
                    }
                    object = "Mk_AI_OFL: Communication successful but response was empty.";
                    return object;
                }
                finally {
                    if (reader != null) {
                        reader.close();
                    }
                }
            }
            for (int i = 0; i < toolCalls.size(); ++i) {
                JsonObject toolCall = toolCalls.getJsonObject(i);
                String functionName = toolCall.getJsonObject("function").getString("name");
                String toolCallId = toolCall.getString("id");
                String result = "OFFLINE";
                if ("admin_connected".equals(functionName)) {
                    System.out.println("  -> Mocking " + functionName + "() -> " + result);
                } else {
                    result = "Feature not available in terminal mode.";
                    System.out.println("  -> Unsupported tool: " + functionName);
                }
                conversation.add(Json.createObjectBuilder().add("role", "tool").add("content", result).add("tool_call_id", toolCallId));
            }
            System.out.println("Resubmitting to AI with tool results...");
            String followUpJson = aiService.chatWithTools(conversation.build().toString());
            try (JsonReader followUpReader = Json.createReader(new StringReader(followUpJson));){
                JsonObject finalMsg = followUpReader.readObject();
                String string = finalMsg.containsKey("content") ? finalMsg.getString("content") : "[Zero deferred to a non-text state after tool call]";
                return string;
            }
        }
        catch (Exception e) {
            return "Error parsing AI response: " + e.getMessage() + "\nRaw: " + rawJson;
        }
    }
}

