/*
 * Decompiled with CFR 0.152.
 */
import com.sysrefiners.enterprise.AIChatRemote;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.animation.FadeTransition;
import javafx.animation.PauseTransition;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.effect.DropShadow;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.stage.Stage;
import javafx.util.Duration;
import javax.naming.Context;
import javax.naming.InitialContext;

public class Main
extends Application {
    private static final Logger LOGGER = Logger.getLogger(Main.class.getName());
    private static final String SERVER_URL = "http-remoting://sysrefiners.com:80";
    private Stage primaryStage;
    private Scene loadingScene;
    private Scene loginScene;
    private Scene chatScene;
    private TextField usernameField;
    private PasswordField passwordField;
    private TextArea outputArea;
    private TextField nameField;
    private Button callEjbButton;
    private AIChatRemote aiService;
    private Context ctx;
    private String loggedInUser;

    public static void main(String[] args) {
        Main.launch(args);
    }

    @Override
    public void start(Stage primaryStage) {
        this.primaryStage = primaryStage;
        primaryStage.setTitle("SysRefiners Secure Client");
        this.initLoadingView();
        this.initLoginView();
        primaryStage.setScene(this.loadingScene);
        primaryStage.show();
        this.playLoadingAnimation();
    }

    private void initLoadingView() {
        VBox root = new VBox();
        root.setAlignment(Pos.CENTER);
        root.setStyle("-fx-background-color: #0f172a;");
        Text logo = new Text("SysRefiners");
        logo.setFont(Font.font("Segoe UI", FontWeight.BOLD, 40.0));
        logo.setFill(Color.web("#38bdf8"));
        logo.setEffect(new DropShadow(20.0, Color.web("#0ea5e9")));
        Text subtitle = new Text("Enterprise Connection");
        subtitle.setFont(Font.font("Segoe UI", FontWeight.THIN, 16.0));
        subtitle.setFill(Color.web("#94a3b8"));
        ProgressIndicator pi = new ProgressIndicator();
        pi.setStyle(" -fx-progress-color: #38bdf8;");
        pi.setMaxSize(50.0, 50.0);
        VBox content = new VBox(20.0, logo, subtitle, pi);
        content.setAlignment(Pos.CENTER);
        root.getChildren().add(content);
        this.loadingScene = new Scene(root, 500.0, 400.0);
    }

    private void playLoadingAnimation() {
        PauseTransition delay = new PauseTransition(Duration.seconds(3.0));
        delay.setOnFinished(e -> this.fadeInScene(this.loginScene));
        delay.play();
    }

    private void fadeInScene(Scene newScene) {
        FadeTransition ftOut = new FadeTransition(Duration.millis(500.0), this.primaryStage.getScene().getRoot());
        ftOut.setFromValue(1.0);
        ftOut.setToValue(0.0);
        ftOut.setOnFinished(e -> {
            this.primaryStage.setScene(newScene);
            FadeTransition ftIn = new FadeTransition(Duration.millis(500.0), newScene.getRoot());
            ftIn.setFromValue(0.0);
            ftIn.setToValue(1.0);
            ftIn.play();
        });
        ftOut.play();
    }

    private void initLoginView() {
        VBox root = new VBox(20.0);
        root.setAlignment(Pos.CENTER);
        root.setPadding(new Insets(40.0));
        root.setStyle("-fx-background-color: #0f172a;");
        Label titleLabel = new Label("Secure Login");
        titleLabel.setFont(Font.font("Segoe UI", FontWeight.BOLD, 24.0));
        titleLabel.setTextFill(Color.web("#f8fafc"));
        this.usernameField = this.styledTextField("Username");
        this.passwordField = this.styledPasswordField("Password");
        Button loginButton = this.styledButton("CONNECT", "#0ea5e9");
        loginButton.setOnAction(e -> this.connectToEjbWithCredentials(this.usernameField.getText().trim(), this.passwordField.getText()));
        VBox form = new VBox(15.0, this.usernameField, this.passwordField, loginButton);
        form.setMaxWidth(300.0);
        form.setAlignment(Pos.CENTER);
        Label footer = new Label("SysRefiners v1.0");
        footer.setTextFill(Color.web("#475569"));
        footer.setFont(Font.font("Segoe UI", 10.0));
        root.getChildren().addAll((Node[])new Node[]{titleLabel, form, footer});
        this.loginScene = new Scene(root, 500.0, 400.0);
    }

    private void initChatView() {
        VBox root = new VBox(15.0);
        root.setPadding(new Insets(20.0));
        root.setStyle("-fx-background-color: #0f172a;");
        HBox header = new HBox();
        header.setAlignment(Pos.CENTER_LEFT);
        Label titleLabel = new Label("SysRefiners Terminal");
        titleLabel.setFont(Font.font("Segoe UI", FontWeight.BOLD, 18.0));
        titleLabel.setTextFill(Color.web("#38bdf8"));
        header.getChildren().add(titleLabel);
        this.outputArea = new TextArea();
        this.outputArea.setEditable(false);
        this.outputArea.setWrapText(true);
        this.outputArea.setPrefHeight(300.0);
        this.outputArea.setStyle("-fx-control-inner-background: #1e293b; -fx-text-fill: #00ff88; -fx-font-family: 'Consolas'; -fx-highlight-fill: #00ff88; -fx-highlight-text-fill: #000;");
        this.nameField = this.styledTextField("Enter command/message...");
        this.nameField.setText("");
        this.callEjbButton = this.styledButton("EXECUTE", "#22c55e");
        this.callEjbButton.setOnAction(e -> this.callEjbMethod());
        HBox inputRow = new HBox(10.0, this.nameField, this.callEjbButton);
        HBox.setHgrow(this.nameField, Priority.ALWAYS);
        root.getChildren().addAll((Node[])new Node[]{header, this.outputArea, inputRow});
        this.chatScene = new Scene(root, 600.0, 500.0);
    }

    private TextField styledTextField(String prompt) {
        TextField tf = new TextField();
        tf.setPromptText(prompt);
        tf.setStyle("-fx-background-color: #1e293b; -fx-text-fill: white; -fx-prompt-text-fill: #64748b; -fx-padding: 10; -fx-background-radius: 5;");
        return tf;
    }

    private PasswordField styledPasswordField(String prompt) {
        PasswordField pf = new PasswordField();
        pf.setPromptText(prompt);
        pf.setStyle("-fx-background-color: #1e293b; -fx-text-fill: white; -fx-prompt-text-fill: #64748b; -fx-padding: 10; -fx-background-radius: 5;");
        return pf;
    }

    private Button styledButton(String text, String colorHex) {
        Button btn = new Button(text);
        btn.setStyle("-fx-background-color: " + colorHex + "; -fx-text-fill: white; -fx-font-weight: bold; -fx-padding: 10 20; -fx-background-radius: 5; -fx-cursor: hand;");
        btn.setOnMouseEntered(e -> btn.setStyle("-fx-background-color: derive(" + colorHex + ", 20%); -fx-text-fill: white; -fx-font-weight: bold; -fx-padding: 10 20; -fx-background-radius: 5; -fx-cursor: hand;"));
        btn.setOnMouseExited(e -> btn.setStyle("-fx-background-color: " + colorHex + "; -fx-text-fill: white; -fx-font-weight: bold; -fx-padding: 10 20; -fx-background-radius: 5; -fx-cursor: hand;"));
        btn.setMinWidth(100.0);
        return btn;
    }

    private void connectToEjbWithCredentials(String username, String password) {
        if (username.isEmpty() || password.isEmpty()) {
            this.showAlert("Please enter both username and password.");
            return;
        }
        LOGGER.info("Connecting to http-remoting://sysrefiners.com:80 as " + username);
        new Thread(() -> {
            try {
                Properties props = new Properties();
                props.put("java.naming.factory.initial", "org.wildfly.naming.client.WildFlyInitialContextFactory");
                props.put("java.naming.provider.url", SERVER_URL);
                props.put("jboss.naming.client.ejb.context", (Object)true);
                props.put("java.naming.security.principal", username);
                props.put("java.naming.security.credentials", password);
                props.put("jboss.naming.client.connect.options.org.xnio.Options.SSL_ENABLED", "true");
                this.ctx = new InitialContext(props);
                String jndiName = "ejb:enterprise-app/enterprise-app-ejb/CommunicationService!com.sysrefiners.enterprise.AIChatRemote";
                this.aiService = (AIChatRemote)this.ctx.lookup(jndiName);
                try {
                    this.aiService.chat("test", username);
                }
                catch (Exception authTest) {
                    throw new SecurityException("Authentication failed: Invalid credentials");
                }
                this.loggedInUser = username;
                Platform.runLater(() -> {
                    this.initChatView();
                    this.fadeInScene(this.chatScene);
                    this.appendOutput("\u2705 Connected to System Mainframe.");
                    this.appendOutput("\ud83d\udc64 Identity Verified: " + username);
                    this.appendOutput("\ud83e\udd16 AI Subsystem: ONLINE");
                });
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Service connection failed", e);
                Platform.runLater(() -> this.showAlert("Connection Error: " + e.getMessage()));
            }
        }).start();
    }

    private void callEjbMethod() {
        String name = this.nameField.getText().trim();
        if (name.isEmpty()) {
            return;
        }
        String finalName = name;
        this.appendOutput("\n> " + finalName);
        this.nameField.clear();
        this.callEjbButton.setDisable(true);
        new Thread(() -> {
            try {
                String userToPass = this.loggedInUser != null ? this.loggedInUser : "Unknown";
                String response = this.aiService.chat(finalName, userToPass);
                Platform.runLater(() -> {
                    this.appendOutput("\n[ZERO]: " + response);
                    this.appendOutput("---------------------");
                    this.callEjbButton.setDisable(false);
                });
            }
            catch (Exception e) {
                Platform.runLater(() -> {
                    this.appendOutput("\u274c COMMAND FAILED: " + e.getMessage());
                    this.callEjbButton.setDisable(false);
                });
                LOGGER.log(Level.SEVERE, "Service method call failed", e);
            }
        }).start();
    }

    private void appendOutput(String text) {
        Platform.runLater(() -> {
            if (this.outputArea != null) {
                this.outputArea.appendText(text + "\n");
                this.outputArea.setScrollTop(Double.MAX_VALUE);
            }
        });
    }

    private void showAlert(String message) {
        Alert alert = new Alert(Alert.AlertType.WARNING);
        alert.setTitle("System Alert");
        alert.setHeaderText(null);
        alert.setContentText(message);
        alert.showAndWait();
    }

    @Override
    public void stop() {
        if (this.ctx != null) {
            try {
                this.ctx.close();
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Failed to close context", e);
            }
        }
    }
}

